
/****************************************************************************/
/* File: tuner.h                                                            */
/* Author: Gary M. Segal                                                    */
/* Copyright (C) 2004,2005,2006 Freescale Semiconductor INC                 */
/****************************************************************************/
/* Description:
/*   This file provides defintions for the Freescale Silicon Tuner MC44S803
/*
/****************************************************************************/
/* revision history:                                                        */
/*                                                                          */
/* Date      Version  Comments                                      Initial */
/* ------------------------------------------------------------------------ */
/* 11/10/04  0.1      Created                                       gms     */
/* 4/8/05    1.0      Power calc support added, MHz Ratio adjusted. gms     */
/*                    realese version.                                      */
/* 7/11/05   1.1      Updated for MC44S802A                         gms     */
/* 10/26/05  1.2      Updated for dual 802A/803 support.            gms     */
/* 11/23/05  1.3      Changed to floating point math.                       */
/* 1/10/06   1.4      Added/corrected defines for circuit adjust    gms     */
/*                    register.                                             */
/* 5/24/06   1.5      Updated for integer only code.  Removed       gms     */
/*                    support for older chips.                              */
/* 8/4/06    1.6      Corrected bug in circuit_adjust struct.       gms     */
/*                                                                          */
/****************************************************************************/
#ifndef _FREESCALE_TUNER_
#define _FREESCALE_TUNER_

/* Define Tuner Versions */
#define MC44S802A   0
#define MC44S803    1

/* Return values for various routines */
#define OK      0
#define FREQ_TO_LOW	-1
#define BIG_ENDIAN 0


/****************************************************************************/
/* Define the scaling factors to allow internal calculations to use 32 bit  */
/* integer math. */
/****************************************************************************/
/* Internally, a value of "100,000" means 1 MHz (i.e. 1=10Hz).  Change      */
/* this to use a different scale.                                           */
/* define MHz (100*1000)

/* Calculate the ratio internal "MHz" to real MHz. Don't change this.       */
/* #define MHzRATIO ((1000*1000)/MHz)

/****************************************************************************/
/* The Digital tune function requires a different scale than the other      */
/* calculations.  Now define the "DigTune" scale and conversion factors.    */

/* For Digital tune,  "10,000" to means 1 MHz (i.e. 1=100Hz).  Change this  */
/* to use a different scale.  This must be equal or smaller than the MHz    */
/* scale defined above.                                                     */
/* #define DIGITUNE_MHZ (10*1000)

/* Caclulate the ratio of internal "MHz" to "Digtune_MHz".  This is used    */
/* to convert scales in the autotune routines.  Don't change this.          */
/* #define DIGITUNE_SCALE (MHz/DIGITUNE_MHZ)

/****************************************************************************/


/* Optimial Settings Structure */

typedef struct {
    int freq;
    unsigned long refdiv;
    unsigned long lo1;
    unsigned long lo2;
    unsigned long digtune_lo1;
    unsigned long digtune_lo2;
} TUNER_SETTINGS_T;


/* Definitions for lo1_frequency field */
#define LO1_STD	0	/* Use standard frequency for 1st LO */
#define LO1_ALT	1	/* Use 1st alternate frequency for 1st LO */
#define LO1_2AL	2	/* Use 2nc alternate frequency for 2nd LO */

#define END_FREQ -1

/* Define Register Names and Address bit values */
#define TUNER_POWERDOWN		0x0000
#define TUNER_REFOSC		0x0001
#define TUNER_REFDIV		0x0002
#define TUNER_MIXREF		0x0003
#define TUNER_RESETSO		0x0004
#define TUNER_LO1			0x0005
#define TUNER_LO2			0x0006
#define TUNER_CIRCUITADJ	0x0007
#define TUNER_TEST			0x0008
#define TUNER_DIGTUNE		0x0009
#define TUNER_LNAAGC		0x000A
#define TUNER_DATA_ADDR		0x000B
#define TUNER_REGTEST		0x000C
#define TUNER_VCOTEST		0x000D
#define TUNER_LNAGAIN		0x000E
#define TUNER_REFAGC		0x000F

/* Define register sizes in bytes.  Size includes address bits */
#define TUNER_POWERDOWN_LEN	3
#define TUNER_REFOSC_LEN	3
#define TUNER_REFDIV_LEN	3	/* Set to 3 to avoid readback errors */
#define TUNER_MIXREF_LEN	3
#define TUNER_RESETSO_LEN	1
#define TUNER_LO1_LEN		3	/* Set to 3 to avoid readback errors */
#define TUNER_LO2_LEN		3
#define TUNER_CIRCUITADJ_LEN 3
#define TUNER_TEST_LEN		3
#define TUNER_DIGTUNE_LEN	3
#define TUNER_LNAAGC_LEN	3
#define TUNER_DATA_ADDR_LEN	2
#define TUNER_REGTEST_LEN	3
#define TUNER_VCOTEST_LEN	3
#define TUNER_LNAGAIN_LEN	3
#define TUNER_REFAGC_LEN	3

#define TUNER_REG_BYTES		4 /* Define the allocated size for all registers */


/* The following bitfield structures define the registers on the silicon tuner.
 * The registers vary in size from 7 to 24 bits.  This file defines all
 * registers in a 32 bit entity with unused bits.  These bitfields were
 * compiled and tested on a Coldfire MCF5307 processor using Metrowerks
 * tools.  These tools create bit fields by allocating fields in the
 * most significant position first.
 */


/* The Generic structure of a tuner register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 28;
			unsigned int Addr : 4;
		} bits;
	} data;
} GENERIC_STRUCT_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int rsvd : 28;
		} bits;
	} data;
} GENERIC_STRUCT_T;
#endif

/****************************************************************************/
/* Power Down Register */


#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 8;
			unsigned int IFPwrDet : 1;
			unsigned int RFPwrDet : 1;
			unsigned int Buf2 : 1;
			unsigned int RefOsc : 1;
			unsigned int AcgAmp : 1;
			unsigned int rsvd1 : 1;
			unsigned int rsvd2 : 1;
			unsigned int IF2 : 1;
			unsigned int IF1 : 1;
			unsigned int LNA : 1;
			unsigned int rsvd3 : 1;
			unsigned int Mix1 : 1;
			unsigned int Synth2 : 1;
			unsigned int CP2 : 1;
			unsigned int Quad : 1;
			unsigned int VCO2 : 1;
			unsigned int Synth1 : 1;
			unsigned int CP1 : 1;
			unsigned int Buf1 : 1;
			unsigned int VCO1  : 1;
			unsigned int Addr : 4;
		} bits;
	} data;
} POWERDOWN_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int VCO1  : 1;
			unsigned int Buf1 : 1;
			unsigned int CP1 : 1;
			unsigned int Synth1 : 1;
			unsigned int VCO2 : 1;
			unsigned int Quad : 1;
			unsigned int CP2 : 1;
			unsigned int Synth2 : 1;
			unsigned int Mix1 : 1;
			unsigned int rsvd3 : 1;
			unsigned int LNA : 1;
			unsigned int IF1 : 1;
			unsigned int IF2 : 1;
			unsigned int rsvd2 : 1;
			unsigned int rsvd1 : 1;
			unsigned int AcgAmp : 1;
			unsigned int RefOsc : 1;
			unsigned int Buf2 : 1;
			unsigned int RFPwrDet : 1;
			unsigned int IFPwrDet : 1;
			unsigned int rsvd : 8;
		} bits;
	} data;
} POWERDOWN_T;
#endif
#define POWERDOWN_OFF	1
#define POWERDOWN_ON	0

/****************************************************************************/
/* Reference Oscillator Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 18;
			unsigned int OscSel : 1;
			unsigned int test : 9; 
			unsigned int Addr : 4;
		} bits;
	} data;
} REFOSC_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int test : 9; 
			unsigned int OscSel : 1;
			unsigned int rsvd : 18;
		} bits;
	} data;
} REFOSC_T;
#endif
#define REFOSC_OSCSEL_4M	0
#define REFOSC_OSCSEL_25M	1
#define REFOSC_TEST        0x040


/****************************************************************************/
/* Programamble R1 & R2 Reference Divider Register  */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 13;
			unsigned int R1Div : 5;
			unsigned int RefBufEn : 1;
			unsigned int R2Div : 9;
			unsigned int Addr : 4;
		} bits;
	} data;
} REFDIV_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int R2Div : 9;
			unsigned int RefBufEn : 1;
			unsigned int R1Div : 5;
			unsigned int rsvd : 13;
		} bits;
	} data;
} REFDIV_T;
#endif
#define REFDIV_REFBUFEN	1 /* RefBufEn is always set */

/****************************************************************************/
/* Mixer and Reference Buffer Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 12;
			unsigned int Mix1 : 2;
			unsigned int QuadGenEn : 1;
			unsigned int ImageReject : 4;
			unsigned int BufIO : 1;
			unsigned int BufGain : 1;
			unsigned int TriState : 1;
			unsigned int OscScr : 1;
			unsigned int Mux4 : 1;
			unsigned int Mux3 : 1;
			unsigned int R3Div : 3;
			unsigned int Addr : 4;
		} bits;
	} data;
} MIXREF_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int R3Div : 3;
			unsigned int Mux3 : 1;
			unsigned int Mux4 : 1;
			unsigned int OscScr : 1;
			unsigned int TriState : 1;
			unsigned int BufGain : 1;
			unsigned int BufIO : 1;
			unsigned int ImageReject : 4;
			unsigned int QuadGenEn : 1;
			unsigned int Mix1 : 2;
			unsigned int rsvd : 12;
		} bits;
	} data;
} MIXREF_T;
#endif
#define MIXREF_BUFGAIN_HALF	0
#define MIXREF_BUFGAIN_FULL	1
#define MIXREF_R3DIV_1		0
#define MIXREF_R3DIV_2		4
#define MIXREF_R3DIV_4		5
#define MIXREF_R3DIV_6		6
#define MIXREF_R3DIV_8		7


/****************************************************************************/
/* Reset / Serial Out Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 25;
			unsigned int SC : 1;
			unsigned int SO : 1;
			unsigned int RS : 1;
			unsigned int Addr : 4;
		} bits;
	} data;
} RESETSO_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int RS : 1;
			unsigned int SO : 1;
			unsigned int SC : 1;
			unsigned int rsvd : 25;
		} bits;
	} data;
} RESETSO_T;
#endif
#define RESESTSO_SO_DISABLE	0
#define RESETTSO_SO_ENABLE	1
#define RESETSO_RS_OPERATE	0
#define RESETSO_RS_RESET	1

/****************************************************************************/
/* Local Oscilator 1 */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 16;
			unsigned int n : 12;
			unsigned int Addr : 4;
		} bits;
	} data;
} LO1_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int n : 12;
			unsigned int rsvd : 16;
		} bits;
	} data;
} LO1_T;
#endif

/****************************************************************************/
/* Local Oscilator 2 */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 13;
			unsigned int n : 15;
			unsigned int Addr : 4;
		} bits;
	} data;
} LO2_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int n : 15;
			unsigned int rsvd : 13;
		} bits;
	} data;
} LO2_T;
#endif

/****************************************************************************/
/* Circuit Adjust Register */

#if BIG_ENDIAN
typedef struct {
    int dataoffset; /* Pointer to the start of data in the "bytes" field */
    int size; /* Number of valid bytes in the "bytes" field */
    int address; /* Internal Chip Address for this register */
    union {
        unsigned long all;
        unsigned char bytes[4];
        struct {
            unsigned int rsvd : 11;
            unsigned int IFDectClear : 1;
            unsigned int RFDectClear : 1;
            unsigned int IFAgcAmpLP : 1;
            unsigned int rsvd1 : 1;
            unsigned int PostAmp2LP : 1;
            unsigned int Mix1LP : 2;
            unsigned int PreAmp1LP : 1;
            unsigned int OutSel : 1;
            unsigned int IFAmpGain : 2;
            unsigned int rsvd2 : 2;
            unsigned int PostAmp2Gain : 1;
            unsigned int rsvd3 : 1;
            unsigned int PreAmp1Gain : 1;
            unsigned int rsvd4 : 1;
            unsigned int Addr : 4;
        } bits;
    } data;
} CIRCUITADJ_T;
#else
typedef struct {
    int dataoffset; /* Pointer to the start of data in the "bytes" field */
    int size; /* Number of valid bytes in the "bytes" field */
    int address; /* Internal Chip Address for this register */
    union {
        unsigned long all;
        unsigned char bytes[4];
        struct {           
            unsigned int Addr : 4;            
            unsigned int rsvd4 : 1;
            unsigned int PreAmp1Gain : 1;
            unsigned int rsvd3 : 1;
            unsigned int PostAmp2Gain : 1;
            unsigned int rsvd2 : 2;
            unsigned int IFAmpGain : 2;
            unsigned int OutSel : 1;
            unsigned int PreAmp1LP : 1;
            unsigned int Mix1LP : 2;
            unsigned int PostAmp2LP : 1;
            unsigned int rsvd1 : 1;
            unsigned int IFAgcAmpLP : 1;
            unsigned int RFDectClear : 1;
            unsigned int IFDectClear : 1;
            unsigned int rsvd : 11;
        } bits;
    } data;
} CIRCUITADJ_T;
#endif

#define CIRCUITADJ_IF_OUT_ANALOG	0
#define CIRCUITADJ_IF_OUT_DIGITAL	1

#define CIRCUITADJ_PREAMP1LP_LOW		0
#define CIRCUITADJ_PREAMP1LP_NOMINAL	1
#define CIRCUITADJ_MIXLP_LOW			0x00
#define CIRCUITADJ_MIXLP_NOMINAL		0X01
#define CIRCUITADJ_MIXLP_MIDDLE			0x02
#define CIRCUITADJ_MIXLP_HIGH			0x03
#define CIRCUITADJ_POSTAMP2LP_LOW		1
#define CIRCUITADJ_POSTAMP2LP_NOMINAL	0 
#define CIRCUITADJ_IFAGCLP_LOW			1
#define CIRCUITADJ_IFAGCLP_NOMINAL		0

#define CIRUITADJ_IFAMPGAIN_6DB			0x0
#define CIRUITADJ_IFAMPGAIN_12DB		0x1
#define CIRUITADJ_IFAMPGAIN_18DB		0x2
#define CIRUITADJ_IFAMPGAIN_20DB		0x3

#define CIRUITADJ_POSTAMP2GAIN_60DB		0x0
#define CIRUITADJ_POSTAMP2GAIN_83DB		0x1

#define CIRCUITADJ_PREAMP1_GAIN_NOMINAL	0
#define CIRCUITADJ_PREAMP1_GAIN_1DB		1


/****************************************************************************/
/* Test Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 9;
			unsigned int rsvd1 : 1;
			unsigned int RL : 1;
			unsigned int RE : 1;
			unsigned int rsvd2 : 1;
			unsigned int AB : 1;
			unsigned int rsvd3 : 5;
			unsigned int GP : 1;
			unsigned int TB : 4;
			unsigned int TA : 4;
			unsigned int Addr : 4;
		} bits;
	} data;
} TEST_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int TA : 4;
			unsigned int TB : 4;
			unsigned int GP : 1;
			unsigned int rsvd3 : 5;
			unsigned int AB : 1;
			unsigned int rsvd2 : 1;
			unsigned int RE : 1;
			unsigned int RL : 1;
			unsigned int rsvd1 : 1;
			unsigned int rsvd : 9;
		} bits;
	} data;
} TEST_T;
#endif

#define TEST_PINA_PLL2_LOCK					0
#define TEST_PINA_VCO1						2
#define TEST_PINA_GPOUT1					3
#define TEST_PINA_PORRST					4
#define TEST_PINA_PLL1_PLL2_LOCK			5
#define TEST_PINA_VCO1_IN_RANGE				6
#define TEST_PINA_PLL1_LOCK					7
#define TEST_PINA_RF1_DIV					8
#define TEST_PINA_PLL2_PROG					9
#define TEST_PINA_VCO1_DIV64				10
#define TEST_PINA_DISABLE					11
#define TEST_PINA_PLLS_LOCKED_VCOS_INRANGE	12
#define TEST_PINA_PHASE_DET1_DOWN			13
#define TEST_PINA_PHASE_DET2_DOWN			14
#define TEST_PINA_REF_OSC_AGC_PDL			15

#define TEST_PINB_SCANOUT			0
#define TEST_PINB_VCO2				1
#define TEST_PINB_GPOUT2			3
#define TEST_PINB_SINEWAVE			4
#define TEST_PINB_VCO2_IN_RANGE		6
#define TEST_PINB_PLL2_LOCK			7
#define TEST_PINB_RF2_DIV			8
#define TEST_PINB_PLL1_PROG			9
#define TEST_PINB_VCO2_DIV64		10
#define TEST_PINB_DISABLE			11
#define TEST_PINB_PHASE_DET1_UP		12
#define TEST_PINB_PHASE_DET2_UP		13
#define TEST_PINB_REF_OSC_AGC_PDH	14
#define TEST_PINB_REF_OSC_AGC_COMP	15



/****************************************************************************/
/* Digitial Tune Module Register										    */
/* Note, this register has several sub-registers that are addressed through */
/* the DT Address (dtaddr) bits.  The following type definition creates     */
/* a union of the different registers formats.  It is up to the user to set */
/* the dtaddr field to match the union field used.                          */
/****************************************************************************/
#if BIG_ENDIAN
typedef struct {
	unsigned int rsvd : 8;
	unsigned int fill2 : 7;
	unsigned int rst : 1;
	unsigned int fil1 : 6;
	unsigned int xod : 2;
	unsigned int rw : 1;
	unsigned int dtaddr : 3;
	unsigned int Addr : 4;
} DIGTUNE_XO_T;

typedef struct {
	unsigned int rsvd : 8;
	unsigned int fill1 : 1;
	unsigned int mt1 : 1;
	unsigned int at1 : 1;
	unsigned int lo1ref : 13;
	unsigned int rw : 1;
	unsigned int dtaddr : 3;
	unsigned int Addr : 4;
} DIGTUNE_LO1_T;

typedef struct {
	unsigned int rsvd : 8;
	unsigned int fill1 : 1;
	unsigned int mt2 : 1;
	unsigned int at2 : 1;
	unsigned int lo2ref : 13;
	unsigned int rw : 1;
	unsigned int dtaddr : 3;
	unsigned int Addr : 4;
} DIGTUNE_LO2_T;

typedef struct {
	unsigned int rsvd : 8;
	unsigned int fill1 : 3;
	unsigned int lo1result : 13;
	unsigned int rw : 1;
	unsigned int dtaddr : 3;
	unsigned int Addr : 4;
} DIGTUNE_LO1RESULT_T;

typedef struct {
	unsigned int rsvd : 8;
	unsigned int fill1 : 3;
	unsigned int lo2result : 13;
	unsigned int rw : 1;
	unsigned int dtaddr : 3;
	unsigned int Addr : 4;
} DIGTUNE_LO2RESULT_T;


/* Here's the defintion of the actual DigTune register.  Note the union of */
/* the above structures, allowing the selection of the different formats   */
/* of the register. */
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		union {
			DIGTUNE_XO_T xo;
			DIGTUNE_LO1_T lo1;
			DIGTUNE_LO2_T lo2;
			DIGTUNE_LO1RESULT_T lo1_result;
			DIGTUNE_LO2RESULT_T lo2_result;
		} bits;
	} data;
} DIGTUNE_T;
#else
typedef struct {
	unsigned int Addr : 4;
	unsigned int dtaddr : 3;
	unsigned int rw : 1;
	unsigned int xod : 2;
	unsigned int fil1 : 6;
	unsigned int rst : 1;
	unsigned int fill2 : 7;
	unsigned int rsvd : 8;
} DIGTUNE_XO_T;

typedef struct {
	unsigned int Addr : 4;
	unsigned int dtaddr : 3;
	unsigned int rw : 1;
	unsigned int lo1ref : 13;
	unsigned int at1 : 1;
	unsigned int mt1 : 1;
	unsigned int fill1 : 1;
	unsigned int rsvd : 8;
} DIGTUNE_LO1_T;

typedef struct {
	unsigned int Addr : 4;
	unsigned int dtaddr : 3;
	unsigned int rw : 1;
	unsigned int lo2ref : 13;
	unsigned int at2 : 1;
	unsigned int mt2 : 1;
	unsigned int fill1 : 1;
	unsigned int rsvd : 8;
} DIGTUNE_LO2_T;

typedef struct {
	unsigned int Addr : 4;
	unsigned int dtaddr : 3;
	unsigned int rw : 1;
	unsigned int lo1result : 13;
	unsigned int fill1 : 3;
	unsigned int rsvd : 8;
} DIGTUNE_LO1RESULT_T;

typedef struct {
	unsigned int Addr : 4;
	unsigned int dtaddr : 3;
	unsigned int rw : 1;
	unsigned int lo2result : 13;
	unsigned int fill1 : 3;
	unsigned int rsvd : 8;
} DIGTUNE_LO2RESULT_T;


/* Here's the defintion of the actual DigTune register.  Note the union of */
/* the above structures, allowing the selection of the different formats   */
/* of the register. */
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		union {
			DIGTUNE_LO2RESULT_T lo2_result;
			DIGTUNE_LO1RESULT_T lo1_result;
			DIGTUNE_LO2_T lo2;
			DIGTUNE_LO1_T lo1;
			DIGTUNE_XO_T xo;
		} bits;
	} data;
} DIGTUNE_T;
#endif

#define DIGTUNE_READ	1
#define DIGTUNE_WRITE	0

#define DIGTUNE_TUNE	1	/* Used to enable auto or manual tune process */

#define DIGTUNE_DTADDR_XO		0
#define DIGTUNE_DTADDR_LO1		1
#define DIGTUNE_DTADDR_LO2		2
#define DIGTUNE_DTADDR_LO1RES	3
#define DIGTUNE_DTADDR_LO2RES	4

#define DIGTUNE_RST_RESET	1
#define DIGTUNE_RST_NORMAL	0
#define DIGTUNE_XOD_4_2_MHZ		0
#define DIGTUNE_XOD_8_2_MHZ 	1
#define DIGTUNE_XOD_16_5_MHZ	2
#define DIGTUNE_XOD_28_0_MHZ	3
#define DIGTUNE_VCOMUX_LOW	0
#define DIGTUNE_VCOMUX_MID	1
#define DIGTUNE_VCOMUX_HIGH	2
#define DIGTUNE_VCOMUX_DISABLE	3

/****************************************************************************/
/* LNA AGC Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			int rsvd : 8;
			int Bias : 2;
			int A0 : 1;
			int AgcSel : 1;
			int Lna0 : 1;
			int ReadEn : 1;
			int HighAtten : 1;
			int AnDig : 1;
			int HlGrEn : 1;
			int rsvd2 : 3;
			int A2 : 1;
			int A1 : 1;
			int NormalAgc : 6;
			int Addr : 4;
		} bits;
	} data;
} LNAAGC_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			int Addr : 4;
			int NormalAgc : 6;
			int A1 : 1;
			int A2 : 1;
			int rsvd2 : 3;
			int HlGrEn : 1;
			int AnDig : 1;
			int HighAtten : 1;
			int ReadEn : 1;
			int Lna0 : 1;
			int AgcSel : 1;
			int A0 : 1;
			int Bias : 2;
			int rsvd : 8;
		} bits;
	} data;
} LNAAGC_T;
#endif

#define LNAAGC_ANDIG_DIGITAL		0
#define LNAAGC_ANDIG_ANALOG			1
#define LNAAGC_AGCSEL_RF0			0
#define LNAAGC_AGCSEL_RF1			1
#define LNAAGC_HIGHATTEN_NORMAL		0
#define LNAAGC_HIGHATTEN_HIGH		1
#define LNAAGC_HIGHLIN_DISABLE		0
#define LNAAGC_HIGHLIN_ENABLE		1
#define LNAAGC_GAIN_MIN             63 /* Note, 0=MAX gain, 63=MIN gain */


/****************************************************************************/
/* Data Adress Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 24;
			unsigned int data_addr : 4;
			unsigned int Addr : 4;
		} bits;
	} data;
} DATA_ADDR_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int Addr : 4;
			unsigned int data_addr : 4;
			unsigned int rsvd : 24;
		} bits;
	} data;
} DATA_ADDR_T;
#endif

/****************************************************************************/
/* Regulater Test Data Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 8;
			unsigned int rsvd1 : 1;
			unsigned int buf1 : 1;
			unsigned int cp1 : 1;
			unsigned int synth1 : 1;
			unsigned int rsvd2 : 1;
			unsigned int buf2 : 1;
			unsigned int cp2 : 1;
			unsigned int synth2 : 1;
			unsigned int quad : 1;
			unsigned int rsvd3 : 2;
			unsigned int lna : 1;
			unsigned int reg18 : 1;
			unsigned int rsvd4 : 7;
			unsigned int AddrRsvd : 4;
		} bits;
	} data;
} REGTEST_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int AddrRsvd : 4;
			unsigned int rsvd4 : 7;
			unsigned int reg18 : 1;
			unsigned int lna : 1;
			unsigned int rsvd3 : 2;
			unsigned int quad : 1;
			unsigned int synth2 : 1;
			unsigned int cp2 : 1;
			unsigned int buf2 : 1;
			unsigned int rsvd2 : 1;
			unsigned int synth1 : 1;
			unsigned int cp1 : 1;
			unsigned int buf1 : 1;
			unsigned int rsvd1 : 1;
			unsigned int rsvd : 8;
		} bits;
	} data;
} REGTEST_T;
#endif

/****************************************************************************/
/* VCO Test Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 8;
			unsigned int rh1 : 1;
			unsigned int rl1 : 1;
			unsigned int rh2 : 1;
			unsigned int rl2 : 1;
			unsigned int ld1 : 1;
			unsigned int ld2 : 1;
			unsigned int rsvd1 : 14;				
			unsigned int AddrRsvd : 4;
		} bits;
	} data;
} VCOTEST_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int AddrRsvd : 4;
			unsigned int rsvd1 : 14;				
			unsigned int ld2 : 1;
			unsigned int ld1 : 1;
			unsigned int rl2 : 1;
			unsigned int rh2 : 1;
			unsigned int rl1 : 1;
			unsigned int rh1 : 1;
			unsigned int rsvd : 8;
		} bits;
	} data;
} VCOTEST_T;
#endif


/****************************************************************************/
/* Current LNA Gain Data Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
		union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 8;
			unsigned int gain : 6;
			unsigned int rfpwr : 3;
			unsigned int ifpwr : 3;
			unsigned int rsvd1 : 8;
			unsigned int AddrRsvd : 4;
		} bits;
	} data;
} LNAGAIN_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
		union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int AddrRsvd : 4;
			unsigned int rsvd1 : 8;
			unsigned int ifpwr : 3;
			unsigned int rfpwr : 3;
			unsigned int gain : 6;
			unsigned int rsvd : 8;
		} bits;
	} data;
} LNAGAIN_T;
#endif

/****************************************************************************/
/* Current Ref AGC Reading Data Register */
#if BIG_ENDIAN
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int rsvd : 8;
			unsigned int refagc : 6;
			unsigned int comp : 1;
			unsigned int pdh : 1;
			unsigned int pdl : 1;
			unsigned int mode : 1;
			unsigned int id : 7;
			unsigned int rsvd1 : 3;
			unsigned int AddrRsvd : 4;
		} bits;
	} data;
} REFAGC_T;
#else
typedef struct {
	int dataoffset; /* Pointer to the start of data in the "bytes" field */
	int size; /* Number of valid bytes in the "bytes" field */
	int address; /* Internal Chip Address for this register */
	union {
		unsigned long all;
		unsigned char bytes[4];
		struct {
			unsigned int AddrRsvd : 4;
			unsigned int rsvd1 : 3;
			unsigned int id : 7;
			unsigned int mode : 1;
			unsigned int pdl : 1;
			unsigned int pdh : 1;
			unsigned int comp : 1;
			unsigned int refagc : 6;
			unsigned int rsvd : 8;
		} bits;
	} data;
} REFAGC_T;
#endif

/****************************************************************************/
/* Define a structure containing all the registers */
typedef struct {
	POWERDOWN_T powerdown;
	REFOSC_T refosc;
	REFDIV_T refdiv;
	MIXREF_T mixref;
	RESETSO_T resetso;
	LO1_T lo1;
	LO2_T lo2;
	CIRCUITADJ_T circuitadj;
	TEST_T test;
	DIGTUNE_T digtune;
	LNAAGC_T lnaagc;
	DATA_ADDR_T data_addr;
	REGTEST_T regtest;
	VCOTEST_T vcotest;
	LNAGAIN_T lnagain;
	REFAGC_T refagc;
} TUNER_REGS_T;


//int MC44S803_i2c_read_tuner_reg (GENERIC_STRUCT_T *tuner_reg);
//int MC44S803_i2c_xmit_tuner_reg (GENERIC_STRUCT_T *tuner_reg);
/* eof */
#endif
